/* Contain the entire script within a function because REPORTER only has a single JavaScript realm
 * for the entire session. */
abdomen_score();

/**
 * Performs the abdomen and abdomen score calculation for the specified models
 */
function abdomen_score() {
    let templ = Template.GetCurrent();
    let models = get_model_list();
    let body_region_label = `abdomen`;

    let occupants = ["DRIVER", "REAR_DRIVER_SIDE"];
    for (let m of models) {
        let capping_limit_explanation = "";
        for (let occ of occupants) {
            LogPrint(`Calculating ${m} ${occ} ${body_region_label} score...`);

            /* Create a status object to track whether REPORTER Variables are all present and valid.
             * <success> is initially true but will be set to false if anything missing or invalid. */
            let status = { success: true, missing: [], invalid: [] };

            /* Abdomen score and modifiers */
            let abdomen_comp_top_max_val;
            let abdomen_comp_bottom_max_val;
            let abdomen_comp_top_max_score;
            let abdomen_comp_bottom_max_score;
            let abdomen_vc_top_max_val;
            let abdomen_vc_bottom_max_val;
            let abdomen_vc_top_max_score;
            let abdomen_vc_bottom_max_score;
            let abdomen_comp_max_01_capping_limit;
            let abdomen_comp_max_02_capping_limit;

            switch (occ) {
                case "DRIVER":
                    abdomen_comp_top_max_val = get_variable_value(
                        status,
                        `${m}_${occ}_ABDOMEN_COMPRESSION_MAX_01_VALUE`,
                        "float"
                    );
                    abdomen_comp_bottom_max_val = get_variable_value(
                        status,
                        `${m}_${occ}_ABDOMEN_COMPRESSION_MAX_02_VALUE`,
                        "float"
                    );
                    abdomen_comp_top_max_score = get_variable_value(
                        status,
                        `${m}_${occ}_ABDOMEN_COMPRESSION_MAX_01_SCORE`,
                        "float"
                    );
                    abdomen_comp_bottom_max_score = get_variable_value(
                        status,
                        `${m}_${occ}_ABDOMEN_COMPRESSION_MAX_02_SCORE`,
                        "float"
                    );
                    abdomen_vc_top_max_val = get_variable_value(
                        status,
                        `${m}_${occ}_ABDOMEN_VISCOUS_CRITERION_UPPER_MAX_VALUE`,
                        "float"
                    );
                    abdomen_vc_bottom_max_val = get_variable_value(
                        status,
                        `${m}_${occ}_ABDOMEN_VISCOUS_CRITERION_LOWER_MAX_VALUE`,
                        "float"
                    );
                    abdomen_vc_top_max_score = get_variable_value(
                        status,
                        `${m}_${occ}_ABDOMEN_VISCOUS_CRITERION_UPPER_MAX_SCORE`,
                        "float"
                    );
                    abdomen_vc_bottom_max_score = get_variable_value(
                        status,
                        `${m}_${occ}_ABDOMEN_VISCOUS_CRITERION_LOWER_MAX_SCORE`,
                        "float"
                    );
                    abdomen_comp_max_01_capping_limit = get_variable_value(
                        status,
                        `${m}_${occ}_ABDOMEN_COMPRESSION_MAX_01_CAPPING_LIMIT`
                    );
                    abdomen_comp_max_02_capping_limit = get_variable_value(
                        status,
                        `${m}_${occ}_ABDOMEN_COMPRESSION_MAX_02_CAPPING_LIMIT`
                    );
                    break;
                case "REAR_DRIVER_SIDE":
                    abdomen_comp_top_max_val = get_variable_value(
                        status,
                        `${m}_${occ}_ABDOMEN_COMPRESSION_REAR_PASSENGER_UPPER_MAX_VALUE`,
                        "float"
                    );
                    abdomen_comp_bottom_max_val = get_variable_value(
                        status,
                        `${m}_${occ}_ABDOMEN_COMPRESSION_REAR_PASSENGER_LOWER_MAX_VALUE`,
                        "float"
                    );
                    abdomen_comp_top_max_score = get_variable_value(
                        status,
                        `${m}_${occ}_ABDOMEN_COMPRESSION_REAR_PASSENGER_UPPER_MAX_SCORE`,
                        "float"
                    );
                    abdomen_comp_bottom_max_score = get_variable_value(
                        status,
                        `${m}_${occ}_ABDOMEN_COMPRESSION_REAR_PASSENGER_LOWER_MAX_SCORE`,
                        "float"
                    );
                    abdomen_vc_top_max_val = get_variable_value(
                        status,
                        `${m}_${occ}_ABDOMEN_VISCOUS_CRITERION_REAR_PASSENGER_UPPER_MAX_VALUE`,
                        "float"
                    );
                    abdomen_vc_bottom_max_val = get_variable_value(
                        status,
                        `${m}_${occ}_ABDOMEN_VISCOUS_CRITERION_REAR_PASSENGER_LOWER_MAX_VALUE`,
                        "float"
                    );
                    abdomen_vc_top_max_score = get_variable_value(
                        status,
                        `${m}_${occ}_ABDOMEN_VISCOUS_CRITERION_REAR_PASSENGER_UPPER_MAX_SCORE`,
                        "float"
                    );
                    abdomen_vc_bottom_max_score = get_variable_value(
                        status,
                        `${m}_${occ}_ABDOMEN_VISCOUS_CRITERION_REAR_PASSENGER_LOWER_MAX_SCORE`,
                        "float"
                    );
                    abdomen_comp_max_01_capping_limit = get_variable_value(
                        status,
                        `${m}_${occ}_ABDOMEN_COMPRESSION_REAR_PASSENGER_UPPER_MAX_CAPPING_LIMIT`
                    );
                    abdomen_comp_max_02_capping_limit = get_variable_value(
                        status,
                        `${m}_${occ}_ABDOMEN_COMPRESSION_REAR_PASSENGER_LOWER_MAX_CAPPING_LIMIT`
                    );
                    break;
                default:
                    LogError(`Unexpected occupant type "${occ}" in ${body_region_label} calculation.`);
                    Exit();
            }
            /* Final scores all start at zero and will remain so if any variables were missing or invalid */
            let abdomen_score_before_mods = 0;
            let abdomen_score = 0;
            let abdomen_vc_mod = 0;
            /* Capping limits start as exceeded and will remain so if any variables were missing or invalid */
            let abdomen_capping_limit = "*";
            

            /* If we have all the required variables, calculate the final scores */
            if (status.success) {
                /*abdomen modification is calculated based on the smaller of the abdomen scores*/
                abdomen_vc_mod = Math.min(abdomen_vc_bottom_max_score, abdomen_vc_top_max_score);

                abdomen_score_before_mods = Math.min(abdomen_comp_top_max_score, abdomen_comp_bottom_max_score);

                abdomen_score = Math.max(0, abdomen_score_before_mods + abdomen_vc_mod);

                /* Check capping limits. If any individual limits are exceeded, an asterisk is
                 * displayed for all parent body regions. */
                if (abdomen_comp_max_01_capping_limit == "" && abdomen_comp_max_02_capping_limit == "") {
                    abdomen_capping_limit = "";
                } else {
                    capping_limit_explanation = `*Capping limit exceeded`;
                }
            } else {
                warn_about_missing_or_invalid_variables(status, `${m} ${occ} ${body_region_label} score calculation`);
            }
            /* Overall scores */

            let abdomen_score_before_mods_var = new Variable(
                templ,
                `${m}_${occ}_ABDOMEN_COMP_SCORE`,
                "Minimum of abdomen compression scores",
                abdomen_score_before_mods.toString(),
                "String",
                false,
                true
            );
            let abdomen_vc_mod_var = new Variable(
                templ,
                `${m}_${occ}_ABDOMEN_VC_MODIFIER`,
                "abdomen VC Modifier",
                abdomen_vc_mod.toString(),
                "String",
                false,
                true
            );

            let abdomen_score_var = new Variable(
                templ,
                `${m}_${occ}_ABDOMEN_FINAL_SCORE`,
                "Final abdomen score",
                abdomen_score.toString(),
                "String",
                false,
                true
            );
            let abdomen_capping_limit_var = new Variable(
                templ,
                `${m}_${occ}_ABDOMEN_CAPPING_LIMIT`,
                `abdomen capping limit`,
                abdomen_capping_limit,
                "String",
                false,
                true
            );
        }
        let capping_limit_explanation_var = new Variable(
            templ,
            `${m}_ABDOMEN_CAPPING_LIMIT_EXPLANATION`,
            `Capping limit explanation`,
            capping_limit_explanation,
            "String",
            false,
            true
        );
    }
}
